/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.snmp;

import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.agent.SnmpMib;
import com.sun.management.snmp.agent.SnmpMibSubRequest;
import com.sun.management.snmp.agent.SnmpMibTable;
import com.sun.management.snmp.agent.SnmpStandardObjectServer;
import java.io.Serializable;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.opends.server.snmp.DsIntEntryMBean;
import org.opends.server.snmp.DsIntEntryMeta;

public class DsIntTableMeta
extends SnmpMibTable
implements Serializable {
    private DsIntEntryMeta node;
    protected SnmpStandardObjectServer objectserver;

    public DsIntTableMeta(SnmpMib myMib, SnmpStandardObjectServer objserv) {
        super(myMib);
        this.objectserver = objserv;
    }

    protected DsIntEntryMeta createDsIntEntryMetaNode(String snmpEntryName, String tableName, SnmpMib mib, MBeanServer server) {
        return new DsIntEntryMeta(mib, this.objectserver);
    }

    public void createNewEntry(SnmpMibSubRequest req, SnmpOid rowOid, int depth) throws SnmpStatusException {
        if (this.factory == null) {
            throw new SnmpStatusException(6);
        }
        this.factory.createNewEntry(req, rowOid, depth, (SnmpMibTable)this);
    }

    public boolean isRegistrationRequired() {
        return false;
    }

    public void registerEntryNode(SnmpMib mib, MBeanServer server) {
        this.node = this.createDsIntEntryMetaNode("DsIntEntry", "DsIntTable", mib, server);
    }

    public synchronized void addEntry(SnmpOid rowOid, ObjectName objname, Object entry) throws SnmpStatusException {
        if (!(entry instanceof DsIntEntryMBean)) {
            throw new ClassCastException("Entries for Table \"DsIntTable\" must implement the \"DsIntEntryMBean\" interface.");
        }
        super.addEntry(rowOid, objname, entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(SnmpMibSubRequest req, SnmpOid rowOid, int depth) throws SnmpStatusException {
        DsIntEntryMBean entry = (DsIntEntryMBean)this.getEntry(rowOid);
        DsIntTableMeta dsIntTableMeta = this;
        synchronized (dsIntTableMeta) {
            this.node.setInstance(entry);
            this.node.get(req, depth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(SnmpMibSubRequest req, SnmpOid rowOid, int depth) throws SnmpStatusException {
        if (req.getSize() == 0) {
            return;
        }
        DsIntEntryMBean entry = (DsIntEntryMBean)this.getEntry(rowOid);
        DsIntTableMeta dsIntTableMeta = this;
        synchronized (dsIntTableMeta) {
            this.node.setInstance(entry);
            this.node.set(req, depth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(SnmpMibSubRequest req, SnmpOid rowOid, int depth) throws SnmpStatusException {
        if (req.getSize() == 0) {
            return;
        }
        DsIntEntryMBean entry = (DsIntEntryMBean)this.getEntry(rowOid);
        DsIntTableMeta dsIntTableMeta = this;
        synchronized (dsIntTableMeta) {
            this.node.setInstance(entry);
            this.node.check(req, depth);
        }
    }

    public void validateVarEntryId(SnmpOid rowOid, long var, Object data) throws SnmpStatusException {
        this.node.validateVarId(var, data);
    }

    public boolean isReadableEntryId(SnmpOid rowOid, long var, Object data) throws SnmpStatusException {
        return this.node.isReadable(var);
    }

    public long getNextVarEntryId(SnmpOid rowOid, long var, Object data) throws SnmpStatusException {
        long nextvar = this.node.getNextVarId(var, data);
        while (!this.isReadableEntryId(rowOid, nextvar, data)) {
            nextvar = this.node.getNextVarId(nextvar, data);
        }
        return nextvar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean skipEntryVariable(SnmpOid rowOid, long var, Object data, int pduVersion) {
        try {
            DsIntEntryMBean entry = (DsIntEntryMBean)this.getEntry(rowOid);
            DsIntTableMeta dsIntTableMeta = this;
            synchronized (dsIntTableMeta) {
                this.node.setInstance(entry);
                return this.node.skipVariable(var, data, pduVersion);
            }
        }
        catch (SnmpStatusException x) {
            return false;
        }
    }
}

